﻿/*
VERSION:		1.5

USAGE:
	#include "walk.as"
	walk_obj = makeWalk( player_mc );
	
NOTES:
	This system has hooks for these collision and sprite systems:
		MakeSprite()			(Sprite system 1 - RpgMaker)
		WalkCollision
	
ADDING COLLISION:
	A collision system can be added like this:
		walk_obj.collision = new WalkCollision( player_mc, walk_obj, collision_array, -8, -8 );
	The walk_obj is this walk system.
*/
makeWalk = function( player_mc, playerImage_mc )
{
	// player_mc				(to alter their position)
	// playerImage_mc		(to alter their pose)
	
	// create container
	var _this = new Object();
	
	// walkSpeed
	_this.walkSpeed = 0.3;		// pixels per frame
	
	
	
	// Make a looping function
	_this.loop = function()
	{
		_this.xVel = 0;
		_this.yVel = 0;
		
		// detect horz keys
		if( Key.isDown(Key.RIGHT) )
		{
			_this.xVel = 1;
			playerImage_mc.setDirection("right");
		}
		else if( Key.isDown(Key.LEFT) )
		{
			_this.xVel = -1;
			playerImage_mc.setDirection("left");
		}
		
		// detect vert keys
		if( Key.isDown(Key.DOWN) )
		{
			_this.yVel = 1;
			playerImage_mc.setDirection("down");
		}
		else if( Key.isDown(Key.UP) )
		{
			_this.yVel = -1;
			playerImage_mc.setDirection("up");
		}
		
		_this.xVel *= _this.walkSpeed;
		_this.yVel *= _this.walkSpeed;
		
		// Apply externally-defined collision
		_this.collision.run();
		
		// start or stop the walk animation
		if (_this.xVel || _this.yVel)
		{
			// is moving
			playerImage_mc.setAnim( true );
		}else{
			// is not moving
			playerImage_mc.setAnim( false );
		}
		
		// Move the player
		player_mc._x += _this.xVel;
		player_mc._y += _this.yVel;
		
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 0.03 );
	
	
	
	// return this system
	return _this;
}// makeWalk()